import React, { Component } from 'react';
import { withStyles } from '@material-ui/core/styles';
import fillTemplate from 'es6-dynamic-template';
import Interweave from 'interweave';
import { SUPPORT_URL } from 'constants/urls';
import routes from 'constants/routes';
import defaultIcon from 'resources/images/models/defaultUnitIcon.svg';
import failBadgeIcon from 'resources/images/fail.svg';
import UnitImageWithBadge from 'components/UnitImageWithBadge';
import StyledButton from 'components/StyledButton';
import styles from './styles';

type Props = {
    strings: object,
    history: History,
    classes: {
        [key: string]: string
    }
};

class DeviceNotRecognized extends Component<Props> {
    onTryAgain() {
        const { history } = this.props;
        // Move to update device screen
        history.replace(routes.UPDATE_DEVICE.path);
    }

    render() {
        const { classes, strings } = this.props;
        return (
            <div className={classes.container}>
                <UnitImageWithBadge
                    imageIcon={defaultIcon}
                    badgeIcon={failBadgeIcon}
                    imageClasses={classes.imageIcon}
                    badgeClasses={classes.badgeIcon}
                />
                <div className={classes.subtitle}>
                    {strings.problem_recognizing_device_error}
                </div>
                <StyledButton
                    variant="outlined"
                    btnSize="big"
                    styles={classes.tryAgain}
                    onClick={() => this.onTryAgain()}
                >
                    {strings.general_button_retry}
                </StyledButton>
                <div className={classes.help}>
                    <Interweave
                        content={fillTemplate(
                            strings.problem_updating_fw_help,
                            { url: SUPPORT_URL }
                        )}
                    />
                </div>
            </div>
        );
    }
}

export default withStyles(styles)(DeviceNotRecognized);
